'use strict';

/* --------------------------------------------------------------
 settings.js 2016-10-04
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Invoices Overview Settings
 *
 * It retrieves the settings data via the user configuration service and sets the values.
 * You are able to change the column sort order and the visibility of each column. Additionally
 * you can change the height of the table rows.
 */
gx.controllers.module('settings', ['user_configuration_service', 'loading_spinner', gx.source + '/libs/overview_settings_modal_controller'], function (data) {

    'use strict';

    // --------------------------------------------------------------------
    // VARIABLES
    // --------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @type {jQuery}
     */

    var $this = $(this);

    /**
     * Module Instance
     *
     * @type {Object}
     */
    var module = {};

    // --------------------------------------------------------------------
    // INITIALIZATION
    // --------------------------------------------------------------------

    module.init = function (done) {
        var SettingsModalController = jse.libs.overview_settings_modal_controller.class;

        var dependencies = {
            element: $this,
            userCfgService: jse.libs.user_configuration_service,
            loadingSpinner: jse.libs.loading_spinner,
            userId: data.userId,
            defaultColumnSettings: data.defaultColumnSettings,
            translator: jse.core.lang,
            page: 'invoices'
        };

        var settingsModal = new SettingsModalController(dependencies.element, dependencies.userCfgService, dependencies.loadingSpinner, dependencies.userId, dependencies.defaultColumnSettings, dependencies.translator, dependencies.page);

        settingsModal.initialize();

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
